/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.item.location;

import dev.felnull.otyacraftengine.item.location.HandItemLocation;
import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class PlayerItemLocations {
    private static final Map<ResourceLocation, Function<CompoundTag, IPlayerItemLocation>> FACTORYS = new HashMap<ResourceLocation, Function<CompoundTag, IPlayerItemLocation>>();
    public static final ResourceLocation HAND = new ResourceLocation("otyacraftengine", "hand");

    public static void init() {
        PlayerItemLocations.register(HAND, HandItemLocation::factory);
    }

    private static void register(ResourceLocation location, Function<CompoundTag, IPlayerItemLocation> factory) {
        FACTORYS.put(location, factory);
    }

    public static IPlayerItemLocation create(ResourceLocation location, CompoundTag tag) {
        Function<CompoundTag, IPlayerItemLocation> f = FACTORYS.get(location);
        if (f != null) {
            return f.apply(tag);
        }
        return null;
    }
}

